<?php
session_start();

// Process form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Store form data in session variables
    $state = $_POST["state"];
    $tariff_type = $_POST["tariff_type"];
    $_SESSION['avg_monthly_consumption'] = $_POST["avg_monthly_consumption"];
    $_SESSION['connected_load'] = isset($_POST["connected_load"]) ? $_POST["connected_load"] : 0;

    // Redirect to the same page to avoid form resubmission
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Calculate energy production based on the given inputs
// This could be done here or after the form submission handling
// For demonstration purposes, I'll leave it here
if (isset($_SESSION['avg_monthly_consumption'])) {
    $avg_monthly_consumption = $_SESSION['avg_monthly_consumption'];
    $connected_load = isset($_SESSION['connected_load']) ? $_SESSION['connected_load'] : 0;


    // Calculate energy production based on the given inputs
    // Add your calculations here based on the state, tariff type, consumption, and connected load

    // For demonstration, let's assume a simple calculation
    $daily_energy = $avg_monthly_consumption / 30; // Assuming uniform consumption throughout the month
    $monthly_energy = $avg_monthly_consumption;
}
?>

<!DOCTYPE html>
<html>

<head>
    <title>Solar Panel Calculator</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/5.0.0-alpha1/css/bootstrap.min.css" integrity="sha384-r4NyP46KrjDleawBgD5tp8Y7UzmLA05oM1iAEQ17CSuDqnUK2+k9luXQOfXJCJ4I" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js" integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/5.0.0-alpha1/js/bootstrap.min.js" integrity="sha384-oesi62hOLfzrys4LxRF63OJCXdXDipiYWBnvTl9Y9/TRlw5xlKIEHpNyvvDShgf/" crossorigin="anonymous"></script>
    <style>
        .result-section {
            display: <?php echo isset($daily_energy) && isset($monthly_energy) ? 'block' : 'none'; ?>;
        }

        .net-cash-flow {
            display: <?php echo isset($daily_energy) && isset($monthly_energy) ? 'none' : 'none'; ?>;
            position: absolute;
            top: 60%;
            left: 50%;
            transform: translate(-50%, 65%);
            background-color: white;
            text-align: center;
            padding: 2%;
        }

        .bill-savings {
            display: <?php echo isset($daily_energy) && isset($monthly_energy) ? 'none' : 'none'; ?>;
            position: absolute;
            top: 60%;
            left: 50%;
            transform: translate(-50%, 61.5%);
            background-color: white;
            text-align: center;
            padding: 2%;
        }
    </style>



</head>

<body style="background-image: url('images/solarpanel.jpg')">
    <section id="input-section" class="input-section">
        <div class="form-align">
            <form class="row g-3" id="input-form" name="input-form" style="background-color: white;" method="POST" onsubmit="return validateForm()" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                <div class="text-center">
                    <h1>Solar Panel Calculator</h1>
                </div>
                <div class="col-md-3">
                    <div>
                        <label for="inputState" class="form-label">State</label>
                        <select name="state" id="state" class="form-select" required onchange="enableTariffType()">
                            <option value="Default">...</option>
                            <option value="Andaman and Nicobar Islands">Andaman and Nicobar Islands</option>
                            <option value="Andhra Pradesh">Andhra Pradesh</option>
                            <option value="Arunachal Pradesh">Arunachal Pradesh</option>
                            <option value="Assam">Assam</option>
                            <option value="Bihar">Bihar</option>
                            <option value="Chhattisgarh">Chhattisgarh</option>
                            <option value="Chandigarh">Chandigarh</option>
                            <option value="Daman and Diu">Daman and Diu</option>
                            <option value="Delhi">Delhi</option>
                            <option value="Dadra and Nagar Haveli">Dadra and Nagar Haveli</option>
                            <option value="Goa">Goa</option>
                            <option value="Gujarat">Gujarat</option>
                            <option value="Himachal Pradesh">Himachal Pradesh</option>
                            <option value="Haryana">Haryana</option>
                            <option value="Jharkhand">Jharkhand</option>
                            <option value="Jammu and Kashmir">Jammu and Kashmir</option>
                            <option value="Kerala">Kerala</option>
                            <option value="Karnataka">Karnataka</option>
                            <option value="Lakshadweep">Lakshadweep</option>
                            <option value="Meghalaya">Meghalaya</option>
                            <option value="Maharastra">Maharastra</option>
                            <option value="Manipur">Manipur</option>
                            <option value="Madhya Pradesh">Madhya Pradesh</option>
                            <option value="Mizoram">Mizoram</option>
                            <option value="Nagaland">Nagaland</option>
                            <option value="Odisha">Odisha</option>
                            <option value="Punjab">Punjab</option>
                            <option value="Puducherry">Puducherry</option>
                            <option value="Rajasthan">Rajasthan</option>
                            <option value="Sikkim">Sikkim</option>
                            <option value="Telangana">Telangana</option>
                            <option value="Tamil Nadu">Tamil Nadu</option>
                            <option value="Tripura">Tripura</option>
                            <option value="Uttarakhand">Uttarakhand</option>
                            <option value="Uttar Pradesh">Uttar Pradesh</option>
                            <option value="West Bengal">West Bengal</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-3">
                    <div>
                        <label for="inputtariff" class="form-label">Tariff Type</label>
                        <select name="tariff_type" id="tariff_type" class="form-select" required disabled>
                            <option value="Default">...</option>
                            <option value="Residential">Residential - Residential</option>
                            <option value="Commercial">Commercial - Commercial</option>
                            <option value="Industrial">Industrial - Industrial</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-3">
                    <div>
                        <label for="inputAMUC" class="form-label">Average Monthly Unit Consumption (KWh)</label>
                        <input type="number" name="avg_monthly_consumption" id="avg_monthly_consumption" value="1000" class="form-control" id="inputCity" required>
                    </div>
                </div>

                <div class="col-md-3">
                    <div>
                        <label for="inputConnLoad" class="form-label">Connected Load In KW (If Known)</label>
                        <input type="number" class="form-control" name="connected_load" id="connected_load">
                    </div>
                </div>

                <div class="col-12">
                    <div class="text-center">
                        <input type="submit" class="btn btn-primary" name="submit" onclick="showResult()" value="Calculate">
                    </div>
                </div>

            </form>
        </div>

        <div class="result-section" id="result-section">
            <?php if (isset($daily_energy) && isset($monthly_energy)) : ?>
                <h2>Your Result:</h2>
                <div>
                    <button type="button" class="btn btn-secondary" onclick="showResult()">Basic Results</button>
                    <button type="button" class="btn btn-secondary" onclick="showNetCashFlow(); loadAdditionalContent();">View Net Cash Outflow</button>
                    <button type="button" class="btn btn-secondary" onclick="showBillSavings()">View Bill & Savings Per Year</button>
                </div>
                <div id="solar-output-overview" class="table BasicResults">
                    <div id="monthly-bill" class="trdiv">
                        <div class="basicresultbx">
                            <p>Average Monthly <br>Bill <b style="font-size: 11px;">[INR]</b></p>
                            <p class="price-ambill"><?php echo round($daily_energy, 2); ?> kWh</p>
                        </div>

                    </div>
                    <div id="km_system_recommended" class="trdiv">
                        <div class="basicresultbx">
                            <p>KW System recommended</p>
                            <p></p>
                        </div>
                    </div>
                    <div id="net-system-cost" class="trdiv">
                        <div class="basicresultbx">
                            <p>Net System Cost <br>after Subsidy <br><b style="font-size: 11px;">if any INR</b></p>
                            <p></p>
                        </div>
                    </div>
                    <div id="size-per-sqft" class="trdiv">
                        <div class="basicresultbx">
                            <p>Size Required (Sq F)</p>
                            <p></p>
                            <p>Size Required (Sq M)</p>
                            <p></p>
                        </div>
                    </div>
                    <div id="est-gen-annually" class="trdiv">
                        <div class="basicresultbx">
                            <p>Estimated <br>generation annually</p>
                            <p><?php echo round($daily_energy, 2); ?>KWH</p>
                        </div>
                    </div>
                    <div id="contribution" class="trdiv">
                        <div class="basicresultbx">
                            <p>Your Contribution <br>to the Environment</p>
                            <p></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="net-cash-flow" id="net-cash-flow">
            <?php if (isset($daily_energy) && isset($monthly_energy)) : ?>
                <h2>Your Result:</h2>
                <div>
                    <button type="button" class="btn btn-secondary" onclick="showResult()">Basic Results</button>
                    <button type="button" class="btn btn-secondary" onclick="showNetCashFlow()">View Net Cash Outflow</button>
                    <button type="button" class="btn btn-secondary" onclick="showBillSavings()">View Bill & Savings Per Year</button>
                </div>
                <div>

                    <canvas id="myChart" style="width:100%; max-width:700px"></canvas>

                </div>
            <?php endif; ?>
        </div>
        <div class="bill-savings" id="bill-savings">
            <?php if (isset($daily_energy) && isset($monthly_energy)) : ?>
                <h2>Your Result:</h2>
                <div>
                    <button type="button" class="btn btn-secondary" onclick="showResult()">Basic Results</button>
                    <button type="button" class="btn btn-secondary" onclick="showNetCashFlow()">View Net Cash Outflow</button>
                    <button type="button" class="btn btn-secondary" onclick="showBillSavings()">View Bill & Savings Per Year</button>
                </div>
                <div>
                    Bill Savings
                    <canvas id="billchart" style="width:100%;max-width:600px"></canvas>
                </div>
            <?php endif; ?>
        </div>
    </section>


    <?php
    session_destroy();
    ?>

    <script>
        function showResult() {
            document.getElementById("result-section").style.display = "block";
            document.getElementById("net-cash-flow").style.display = "none";
            document.getElementById("bill-savings").style.display = "none";
        }


        // function showBasicResult() {
        //     document.getElementById("basic-result").style.display = "block";
        //     document.getElementById("net-cash-flow").style.display = "none";
        //     document.getElementById("bill-savings").style.display = "none";
        // }

        function showNetCashFlow() {
            document.getElementById("result-section").style.display = "none";
            document.getElementById("net-cash-flow").style.display = "block";
            document.getElementById("bill-savings").style.display = "none";
        }

        function showBillSavings() {
            document.getElementById("result-section").style.display = "none";
            document.getElementById("net-cash-flow").style.display = "none";
            document.getElementById("bill-savings").style.display = "block";
        }

        function enableTariffType() {
            var stateSelect = document.getElementById("state");
            var tariffTypeSelect = document.getElementById("tariff_type");
            if (stateSelect.value !== "Default") {
                tariffTypeSelect.disabled = false;
            } else {
                tariffTypeSelect.disabled = true;
                tariffTypeSelect.value == "Default";
            }
        }

        function validateForm() {
            var stateSelect = document.getElementById("state");
            var tariffTypeSelect = document.getElementById("tariff_type");

            if (stateSelect.value === "Default" || tariffTypeSelect.value === "Default") {
                alert("Please enter the State and Tariff type to perform the calculation.");
                return false;
            }
            return true;
        }
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js">
    </script>
    <script>
        const xValues = ["Italy", "France", "Spain", "USA", "Argentina"];
        const yValues = [55, 49, 44, 24, 15];
        const barColors = ["red", "green", "blue", "orange", "brown"];

        new Chart("myChart", {
            type: "bar",
            data: {
                labels: xValues,
                datasets: [{
                    backgroundColor: barColors,
                    data: yValues
                }]
            },
            options: {
                legend: {
                    display: false
                },
                title: {
                    display: true,
                    text: "NET CASH OUTFLOW"
                }
            }
        });
    </script>
    <script>
        const fValues = [100, 200, 300, 400, 500, 600, 700, 800, 900, 1000];

        new Chart("billchart", {
            type: "line",
            data: {
                labels: fValues,
                datasets: [{
                    data: [860, 1140, 1060, 1060, 1070, 1110, 1330, 1400, 1500, 1600],
                    borderColor: "red",
                    fill: false
                }, {
                    data: [1600, 1700, 1700, 1900, 2000, 2700, 4000, 5000, 6000, 7000],
                    borderColor: "green",
                    fill: false
                }]
            },
            options: {
                legend: {
                    display: false
                }
            }
        });
    </script>
</body>

</html>